/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.fuin.utils4j.LockingFailedException;
import org.fuin.utils4j.MergeException;
import org.fuin.utils4j.Property;
import org.fuin.utils4j.RandomAccessFileInputStream;
import org.fuin.utils4j.RandomAccessFileOutputStream;

public class PropertiesFile {
    private final File file;
    private final String encoding;
    private final List props;
    private int tryLockMax = 3;
    private long tryWaitMillis = 100L;
    private boolean loaded = false;

    public PropertiesFile(File file) {
        this(file, "UTF-8");
    }

    public PropertiesFile(File file, String encoding) {
        this.file = file;
        this.encoding = encoding;
        this.props = new ArrayList();
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final boolean isLoaded() {
        return this.loaded;
    }

    public final void clear() {
        this.props.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() throws IOException, LockingFailedException, MergeException {
        try (RandomAccessFileInputStream in = new RandomAccessFileInputStream(this.file, "rw");){
            FileLock lock = in.lock(this.tryLockMax, this.tryWaitMillis);
            try {
                this.merge(in);
            }
            finally {
                lock.release();
            }
        }
    }

    private void load(RandomAccessFileInputStream in, File file, List props, String encoding) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new BufferedInputStream(in), encoding));
        while ((line = reader.readLine()) != null) {
            int p = line.indexOf(61);
            if (p <= -1) continue;
            String key = line.substring(0, p);
            String value = line.substring(p + 1);
            props.add(new Property(key, value, value));
        }
        this.loaded = true;
    }

    private void merge(RandomAccessFileInputStream in) throws MergeException, IOException {
        ArrayList<MergeException.Problem> problems = new ArrayList<MergeException.Problem>();
        ArrayList currentProps = new ArrayList();
        this.load(in, this.file, currentProps, this.encoding);
        for (int i = 0; i < currentProps.size(); ++i) {
            Property currentProp = (Property)currentProps.get(i);
            int idx = this.props.indexOf(currentProp);
            if (idx == -1) {
                this.props.add(currentProp);
                continue;
            }
            Property prop = (Property)this.props.get(idx);
            if (prop.hasChanged()) {
                if (prop.isNew()) {
                    if (prop.getValue().equals(currentProp.getValue())) continue;
                    problems.add(new MergeException.Problem("Same new property in file with a different value!", prop, currentProp));
                    continue;
                }
                if (prop.isDeleted()) {
                    if (prop.getInitialValue().equals(currentProp.getValue())) continue;
                    problems.add(new MergeException.Problem("Modified property in file we want to delete!", prop, currentProp));
                    continue;
                }
                if (prop.getInitialValue().equals(currentProp.getValue())) continue;
                problems.add(new MergeException.Problem("Same property modified in file but different value!", prop, currentProp));
                continue;
            }
            this.props.set(idx, currentProp);
        }
        if (problems.size() > 0) {
            throw new MergeException(this.file, problems.toArray(new MergeException.Problem[0]));
        }
    }

    public final void save(boolean sortByKey) throws IOException, MergeException, LockingFailedException {
        this.save(new String[0], sortByKey);
    }

    public final void save(String comment, boolean sortByKey) throws IOException, MergeException, LockingFailedException {
        this.save(new String[]{comment}, sortByKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(String[] comments, boolean sortByKey) throws IOException, MergeException, LockingFailedException {
        try (RandomAccessFileOutputStream out = new RandomAccessFileOutputStream(this.file, "rw");){
            FileLock lock = out.lock(this.tryLockMax, this.tryWaitMillis);
            try {
                int i;
                this.merge(new RandomAccessFileInputStream(out));
                out.seek(0L);
                out.resetCounter();
                if (sortByKey) {
                    Collections.sort(this.props);
                }
                BufferedOutputStream bout = new BufferedOutputStream(out);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bout, this.encoding);
                String lf = System.getProperty("line.separator");
                for (i = 0; i < comments.length; ++i) {
                    writer.write("# ");
                    writer.write(comments[i]);
                    writer.write(lf);
                }
                for (i = 0; i < this.props.size(); ++i) {
                    Property prop = (Property)this.props.get(i);
                    if (prop.isDeleted()) continue;
                    writer.write(prop.toKeyValue());
                    writer.write(lf);
                    this.props.set(i, new Property(prop.getKey(), prop.getValue(), prop.getValue()));
                }
                ((Writer)writer).flush();
                out.truncate();
                out.flush();
            }
            finally {
                lock.release();
            }
        }
        for (int i = this.props.size() - 1; i >= 0; --i) {
            Property prop = (Property)this.props.get(i);
            if (!prop.isDeleted()) continue;
            this.props.remove(i);
        }
    }

    private Property find(String key) {
        for (int i = 0; i < this.props.size(); ++i) {
            Property prop = (Property)this.props.get(i);
            if (!prop.getKey().equals(key)) continue;
            return prop;
        }
        return null;
    }

    public final String get(String key) {
        Property prop = this.find(key);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    public final String getStatus(String key) {
        Property prop = this.find(key);
        if (prop == null) {
            return null;
        }
        return prop.getStatus();
    }

    public final void put(String key, String value) {
        Property prop = this.find(key);
        if (prop == null) {
            this.props.add(new Property(key, null, value));
        } else {
            prop.setValue(value);
        }
    }

    public final void remove(String key) {
        Property prop = this.find(key);
        if (prop != null) {
            prop.setValue(null);
        }
    }

    public final boolean isRemoved(String key) {
        Property prop = this.find(key);
        if (prop == null) {
            return true;
        }
        return prop.isDeleted();
    }

    public final int size() {
        return this.props.size();
    }

    public final File getFile() {
        return this.file;
    }

    public final List getKeyList() {
        ArrayList keys = new ArrayList();
        Iterator it = this.keyIterator();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        return keys;
    }

    public final String[] getKeyArray() {
        return this.getKeyList().toArray(new String[0]);
    }

    public final Iterator keyIterator() {
        return new Iterator(){
            private final Iterator it;
            {
                this.it = PropertiesFile.this.props.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            public Object next() {
                Property prop = (Property)this.it.next();
                return prop.getKey();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    public final Properties toProperties() {
        Properties retVal = new Properties();
        for (int i = 0; i < this.props.size(); ++i) {
            Property prop = (Property)this.props.get(i);
            if (prop.isDeleted()) continue;
            retVal.put(prop.getKey(), prop.getValue());
        }
        return retVal;
    }

    public final int getTryLockMax() {
        return this.tryLockMax;
    }

    public final void setTryLockMax(int tryLockMax) {
        this.tryLockMax = tryLockMax;
    }

    public final long getTryWaitMillis() {
        return this.tryWaitMillis;
    }

    public final void setTryWaitMillis(long tryWaitMillis) {
        this.tryWaitMillis = tryWaitMillis;
    }

    public final boolean exists() {
        return this.file.exists();
    }

    public final boolean delete() {
        return this.file.delete();
    }
}

